@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ClusterConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property executeCommandConfiguration Details of the execute command configuration. See `execute_command_configuration` Block for details.
 * @property managedStorageConfiguration Details of the managed storage configuration. See `managed_storage_configuration` Block for details.
 */
public data class ClusterConfigurationArgs(
    public val executeCommandConfiguration: Output<ClusterConfigurationExecuteCommandConfigurationArgs>? = null,
    public val managedStorageConfiguration: Output<ClusterConfigurationManagedStorageConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ClusterConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ClusterConfigurationArgs =
        com.pulumi.aws.ecs.inputs.ClusterConfigurationArgs.builder()
            .executeCommandConfiguration(
                executeCommandConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .managedStorageConfiguration(
                managedStorageConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterConfigurationArgs].
 */
@PulumiTagMarker
public class ClusterConfigurationArgsBuilder internal constructor() {
    private var executeCommandConfiguration:
        Output<ClusterConfigurationExecuteCommandConfigurationArgs>? = null

    private var managedStorageConfiguration:
        Output<ClusterConfigurationManagedStorageConfigurationArgs>? = null

    /**
     * @param value Details of the execute command configuration. See `execute_command_configuration` Block for details.
     */
    @JvmName("chvugdxaqqwikdwm")
    public suspend fun executeCommandConfiguration(`value`: Output<ClusterConfigurationExecuteCommandConfigurationArgs>) {
        this.executeCommandConfiguration = value
    }

    /**
     * @param value Details of the managed storage configuration. See `managed_storage_configuration` Block for details.
     */
    @JvmName("awdfqpublnoimthu")
    public suspend fun managedStorageConfiguration(`value`: Output<ClusterConfigurationManagedStorageConfigurationArgs>) {
        this.managedStorageConfiguration = value
    }

    /**
     * @param value Details of the execute command configuration. See `execute_command_configuration` Block for details.
     */
    @JvmName("mvkvcqksymvewgip")
    public suspend fun executeCommandConfiguration(`value`: ClusterConfigurationExecuteCommandConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executeCommandConfiguration = mapped
    }

    /**
     * @param argument Details of the execute command configuration. See `execute_command_configuration` Block for details.
     */
    @JvmName("wrgyddmtfengwutm")
    public suspend fun executeCommandConfiguration(argument: suspend ClusterConfigurationExecuteCommandConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterConfigurationExecuteCommandConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.executeCommandConfiguration = mapped
    }

    /**
     * @param value Details of the managed storage configuration. See `managed_storage_configuration` Block for details.
     */
    @JvmName("kuihgabjtdufvkvn")
    public suspend fun managedStorageConfiguration(`value`: ClusterConfigurationManagedStorageConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedStorageConfiguration = mapped
    }

    /**
     * @param argument Details of the managed storage configuration. See `managed_storage_configuration` Block for details.
     */
    @JvmName("pubphuwhrcuxltug")
    public suspend fun managedStorageConfiguration(argument: suspend ClusterConfigurationManagedStorageConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterConfigurationManagedStorageConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.managedStorageConfiguration = mapped
    }

    internal fun build(): ClusterConfigurationArgs = ClusterConfigurationArgs(
        executeCommandConfiguration = executeCommandConfiguration,
        managedStorageConfiguration = managedStorageConfiguration,
    )
}
