@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ClusterConfigurationExecuteCommandConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyId AWS Key Management Service key ID to encrypt the data between the local client and the container.
 * @property logConfiguration Log configuration for the results of the execute command actions. Required when `logging` is `OVERRIDE`. See `log_configuration` Block for details.
 * @property logging Log setting to use for redirecting logs for your execute command results. Valid values: `NONE`, `DEFAULT`, `OVERRIDE`.
 */
public data class ClusterConfigurationExecuteCommandConfigurationArgs(
    public val kmsKeyId: Output<String>? = null,
    public val logConfiguration: Output<ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs>? = null,
    public val logging: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ClusterConfigurationExecuteCommandConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ClusterConfigurationExecuteCommandConfigurationArgs =
        com.pulumi.aws.ecs.inputs.ClusterConfigurationExecuteCommandConfigurationArgs.builder()
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .logConfiguration(logConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .logging(logging?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterConfigurationExecuteCommandConfigurationArgs].
 */
@PulumiTagMarker
public class ClusterConfigurationExecuteCommandConfigurationArgsBuilder internal constructor() {
    private var kmsKeyId: Output<String>? = null

    private var logConfiguration:
        Output<ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs>? = null

    private var logging: Output<String>? = null

    /**
     * @param value AWS Key Management Service key ID to encrypt the data between the local client and the container.
     */
    @JvmName("fvaecwryiaqfrjud")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Log configuration for the results of the execute command actions. Required when `logging` is `OVERRIDE`. See `log_configuration` Block for details.
     */
    @JvmName("rqdewusctqmbnnag")
    public suspend fun logConfiguration(`value`: Output<ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs>) {
        this.logConfiguration = value
    }

    /**
     * @param value Log setting to use for redirecting logs for your execute command results. Valid values: `NONE`, `DEFAULT`, `OVERRIDE`.
     */
    @JvmName("wxastdvougtpblxu")
    public suspend fun logging(`value`: Output<String>) {
        this.logging = value
    }

    /**
     * @param value AWS Key Management Service key ID to encrypt the data between the local client and the container.
     */
    @JvmName("trxrdxdtvydnbtkv")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Log configuration for the results of the execute command actions. Required when `logging` is `OVERRIDE`. See `log_configuration` Block for details.
     */
    @JvmName("nmsyiodcaoynrhno")
    public suspend fun logConfiguration(`value`: ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logConfiguration = mapped
    }

    /**
     * @param argument Log configuration for the results of the execute command actions. Required when `logging` is `OVERRIDE`. See `log_configuration` Block for details.
     */
    @JvmName("ploxorssmexsosox")
    public suspend fun logConfiguration(argument: suspend ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.logConfiguration = mapped
    }

    /**
     * @param value Log setting to use for redirecting logs for your execute command results. Valid values: `NONE`, `DEFAULT`, `OVERRIDE`.
     */
    @JvmName("syqsxiqrflkfwsba")
    public suspend fun logging(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logging = mapped
    }

    internal fun build(): ClusterConfigurationExecuteCommandConfigurationArgs =
        ClusterConfigurationExecuteCommandConfigurationArgs(
            kmsKeyId = kmsKeyId,
            logConfiguration = logConfiguration,
            logging = logging,
        )
}
