@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ClusterConfigurationManagedStorageConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fargateEphemeralStorageKmsKeyId AWS Key Management Service key ID for the Fargate ephemeral storage.
 * @property kmsKeyId AWS Key Management Service key ID to encrypt the managed storage.
 */
public data class ClusterConfigurationManagedStorageConfigurationArgs(
    public val fargateEphemeralStorageKmsKeyId: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ClusterConfigurationManagedStorageConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ClusterConfigurationManagedStorageConfigurationArgs =
        com.pulumi.aws.ecs.inputs.ClusterConfigurationManagedStorageConfigurationArgs.builder()
            .fargateEphemeralStorageKmsKeyId(fargateEphemeralStorageKmsKeyId?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterConfigurationManagedStorageConfigurationArgs].
 */
@PulumiTagMarker
public class ClusterConfigurationManagedStorageConfigurationArgsBuilder internal constructor() {
    private var fargateEphemeralStorageKmsKeyId: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    /**
     * @param value AWS Key Management Service key ID for the Fargate ephemeral storage.
     */
    @JvmName("wuptujkdojnjvbxj")
    public suspend fun fargateEphemeralStorageKmsKeyId(`value`: Output<String>) {
        this.fargateEphemeralStorageKmsKeyId = value
    }

    /**
     * @param value AWS Key Management Service key ID to encrypt the managed storage.
     */
    @JvmName("xacekettbsfjpfmg")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value AWS Key Management Service key ID for the Fargate ephemeral storage.
     */
    @JvmName("gnvbndkyrlnvppsf")
    public suspend fun fargateEphemeralStorageKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fargateEphemeralStorageKmsKeyId = mapped
    }

    /**
     * @param value AWS Key Management Service key ID to encrypt the managed storage.
     */
    @JvmName("eebktpdyuvrtkerj")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    internal fun build(): ClusterConfigurationManagedStorageConfigurationArgs =
        ClusterConfigurationManagedStorageConfigurationArgs(
            fargateEphemeralStorageKmsKeyId = fargateEphemeralStorageKmsKeyId,
            kmsKeyId = kmsKeyId,
        )
}
