@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.GetContainerDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getContainerDefinition.
 * @property containerName Name of the container definition
 * @property taskDefinition ARN of the task definition which contains the container
 */
public data class GetContainerDefinitionPlainArgs(
    public val containerName: String,
    public val taskDefinition: String,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.GetContainerDefinitionPlainArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.GetContainerDefinitionPlainArgs =
        com.pulumi.aws.ecs.inputs.GetContainerDefinitionPlainArgs.builder()
            .containerName(containerName.let({ args0 -> args0 }))
            .taskDefinition(taskDefinition.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContainerDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetContainerDefinitionPlainArgsBuilder internal constructor() {
    private var containerName: String? = null

    private var taskDefinition: String? = null

    /**
     * @param value Name of the container definition
     */
    @JvmName("uwjcrrhpkyuxnidj")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerName = mapped
    }

    /**
     * @param value ARN of the task definition which contains the container
     */
    @JvmName("lctcpjpxyyartplm")
    public suspend fun taskDefinition(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.taskDefinition = mapped
    }

    internal fun build(): GetContainerDefinitionPlainArgs = GetContainerDefinitionPlainArgs(
        containerName = containerName ?: throw PulumiNullFieldException("containerName"),
        taskDefinition = taskDefinition ?: throw PulumiNullFieldException("taskDefinition"),
    )
}
