@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.GetTaskDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTaskDefinition.
 * @property taskDefinition Family for the latest ACTIVE revision, family and revision (family:revision) for a specific revision in the family, the ARN of the task definition to access to.
 */
public data class GetTaskDefinitionPlainArgs(
    public val taskDefinition: String,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.GetTaskDefinitionPlainArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.GetTaskDefinitionPlainArgs =
        com.pulumi.aws.ecs.inputs.GetTaskDefinitionPlainArgs.builder()
            .taskDefinition(taskDefinition.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTaskDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetTaskDefinitionPlainArgsBuilder internal constructor() {
    private var taskDefinition: String? = null

    /**
     * @param value Family for the latest ACTIVE revision, family and revision (family:revision) for a specific revision in the family, the ARN of the task definition to access to.
     */
    @JvmName("agcssnvbjhhiiebj")
    public suspend fun taskDefinition(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.taskDefinition = mapped
    }

    internal fun build(): GetTaskDefinitionPlainArgs = GetTaskDefinitionPlainArgs(
        taskDefinition = taskDefinition ?: throw PulumiNullFieldException("taskDefinition"),
    )
}
