@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.GetTaskExecutionCapacityProviderStrategy.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property base The number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Defaults to `0`.
 * @property capacityProvider Name of the capacity provider.
 * @property weight The relative percentage of the total number of launched tasks that should use the specified capacity provider. The `weight` value is taken into consideration after the `base` count of tasks has been satisfied. Defaults to `0`.
 */
public data class GetTaskExecutionCapacityProviderStrategy(
    public val base: Int? = null,
    public val capacityProvider: String,
    public val weight: Int? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.GetTaskExecutionCapacityProviderStrategy> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.GetTaskExecutionCapacityProviderStrategy =
        com.pulumi.aws.ecs.inputs.GetTaskExecutionCapacityProviderStrategy.builder()
            .base(base?.let({ args0 -> args0 }))
            .capacityProvider(capacityProvider.let({ args0 -> args0 }))
            .weight(weight?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTaskExecutionCapacityProviderStrategy].
 */
@PulumiTagMarker
public class GetTaskExecutionCapacityProviderStrategyBuilder internal constructor() {
    private var base: Int? = null

    private var capacityProvider: String? = null

    private var weight: Int? = null

    /**
     * @param value The number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Defaults to `0`.
     */
    @JvmName("nekbvcfvixjsswgw")
    public suspend fun base(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.base = mapped
    }

    /**
     * @param value Name of the capacity provider.
     */
    @JvmName("avxshsqnbmaqfpvt")
    public suspend fun capacityProvider(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.capacityProvider = mapped
    }

    /**
     * @param value The relative percentage of the total number of launched tasks that should use the specified capacity provider. The `weight` value is taken into consideration after the `base` count of tasks has been satisfied. Defaults to `0`.
     */
    @JvmName("jsvprblelkoaktbb")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.weight = mapped
    }

    internal fun build(): GetTaskExecutionCapacityProviderStrategy =
        GetTaskExecutionCapacityProviderStrategy(
            base = base,
            capacityProvider = capacityProvider ?: throw PulumiNullFieldException("capacityProvider"),
            weight = weight,
        )
}
