@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.GetTaskExecutionOverridesInferenceAcceleratorOverride.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName The Elastic Inference accelerator device name to override for the task. This parameter must match a deviceName specified in the task definition.
 * @property deviceType The Elastic Inference accelerator type to use.
 */
public data class GetTaskExecutionOverridesInferenceAcceleratorOverride(
    public val deviceName: String? = null,
    public val deviceType: String? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ecs.inputs.GetTaskExecutionOverridesInferenceAcceleratorOverride> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.GetTaskExecutionOverridesInferenceAcceleratorOverride =
        com.pulumi.aws.ecs.inputs.GetTaskExecutionOverridesInferenceAcceleratorOverride.builder()
            .deviceName(deviceName?.let({ args0 -> args0 }))
            .deviceType(deviceType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTaskExecutionOverridesInferenceAcceleratorOverride].
 */
@PulumiTagMarker
public class GetTaskExecutionOverridesInferenceAcceleratorOverrideBuilder internal constructor() {
    private var deviceName: String? = null

    private var deviceType: String? = null

    /**
     * @param value The Elastic Inference accelerator device name to override for the task. This parameter must match a deviceName specified in the task definition.
     */
    @JvmName("giedfrmrvxwjoace")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.deviceName = mapped
    }

    /**
     * @param value The Elastic Inference accelerator type to use.
     */
    @JvmName("pehniunxyehegxtv")
    public suspend fun deviceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.deviceType = mapped
    }

    internal fun build(): GetTaskExecutionOverridesInferenceAcceleratorOverride =
        GetTaskExecutionOverridesInferenceAcceleratorOverride(
            deviceName = deviceName,
            deviceType = deviceType,
        )
}
