@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.GetTaskExecutionPlacementConstraint.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expression A cluster query language expression to apply to the constraint. The expression can have a maximum length of 2000 characters. You can't specify an expression if the constraint type is `distinctInstance`.
 * @property type The type of constraint. Valid values are `distinctInstance` or `memberOf`. Use `distinctInstance` to ensure that each task in a particular group is running on a different container instance. Use `memberOf` to restrict the selection to a group of valid candidates.
 */
public data class GetTaskExecutionPlacementConstraint(
    public val expression: String? = null,
    public val type: String,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.GetTaskExecutionPlacementConstraint> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.GetTaskExecutionPlacementConstraint =
        com.pulumi.aws.ecs.inputs.GetTaskExecutionPlacementConstraint.builder()
            .expression(expression?.let({ args0 -> args0 }))
            .type(type.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTaskExecutionPlacementConstraint].
 */
@PulumiTagMarker
public class GetTaskExecutionPlacementConstraintBuilder internal constructor() {
    private var expression: String? = null

    private var type: String? = null

    /**
     * @param value A cluster query language expression to apply to the constraint. The expression can have a maximum length of 2000 characters. You can't specify an expression if the constraint type is `distinctInstance`.
     */
    @JvmName("ffpocbqnqvbliuft")
    public suspend fun expression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expression = mapped
    }

    /**
     * @param value The type of constraint. Valid values are `distinctInstance` or `memberOf`. Use `distinctInstance` to ensure that each task in a particular group is running on a different container instance. Use `memberOf` to restrict the selection to a group of valid candidates.
     */
    @JvmName("qvlxwwfavvgrcxuy")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetTaskExecutionPlacementConstraint = GetTaskExecutionPlacementConstraint(
        expression = expression,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
