@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceAlarmsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property alarmNames One or more CloudWatch alarm names.
 * @property enable Whether to use the CloudWatch alarm option in the service deployment process.
 * @property rollback Whether to configure Amazon ECS to roll back the service if a service deployment fails. If rollback is used, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
 */
public data class ServiceAlarmsArgs(
    public val alarmNames: Output<List<String>>,
    public val enable: Output<Boolean>,
    public val rollback: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceAlarmsArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ServiceAlarmsArgs =
        com.pulumi.aws.ecs.inputs.ServiceAlarmsArgs.builder()
            .alarmNames(alarmNames.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .enable(enable.applyValue({ args0 -> args0 }))
            .rollback(rollback.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceAlarmsArgs].
 */
@PulumiTagMarker
public class ServiceAlarmsArgsBuilder internal constructor() {
    private var alarmNames: Output<List<String>>? = null

    private var enable: Output<Boolean>? = null

    private var rollback: Output<Boolean>? = null

    /**
     * @param value One or more CloudWatch alarm names.
     */
    @JvmName("srekdxahrmbfojbv")
    public suspend fun alarmNames(`value`: Output<List<String>>) {
        this.alarmNames = value
    }

    @JvmName("vgyarebhcimtvltr")
    public suspend fun alarmNames(vararg values: Output<String>) {
        this.alarmNames = Output.all(values.asList())
    }

    /**
     * @param values One or more CloudWatch alarm names.
     */
    @JvmName("kdgoldtoiksbinui")
    public suspend fun alarmNames(values: List<Output<String>>) {
        this.alarmNames = Output.all(values)
    }

    /**
     * @param value Whether to use the CloudWatch alarm option in the service deployment process.
     */
    @JvmName("fhkerhjnlheesxru")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Whether to configure Amazon ECS to roll back the service if a service deployment fails. If rollback is used, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
     */
    @JvmName("ypgrrmaxdtkxdwnu")
    public suspend fun rollback(`value`: Output<Boolean>) {
        this.rollback = value
    }

    /**
     * @param value One or more CloudWatch alarm names.
     */
    @JvmName("eucuikouygmtctod")
    public suspend fun alarmNames(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alarmNames = mapped
    }

    /**
     * @param values One or more CloudWatch alarm names.
     */
    @JvmName("deoxhirmqshyjnen")
    public suspend fun alarmNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alarmNames = mapped
    }

    /**
     * @param value Whether to use the CloudWatch alarm option in the service deployment process.
     */
    @JvmName("yowhaiajmaafksag")
    public suspend fun enable(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Whether to configure Amazon ECS to roll back the service if a service deployment fails. If rollback is used, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
     */
    @JvmName("vtwqbueihknarlkx")
    public suspend fun rollback(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rollback = mapped
    }

    internal fun build(): ServiceAlarmsArgs = ServiceAlarmsArgs(
        alarmNames = alarmNames ?: throw PulumiNullFieldException("alarmNames"),
        enable = enable ?: throw PulumiNullFieldException("enable"),
        rollback = rollback ?: throw PulumiNullFieldException("rollback"),
    )
}
