@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceCapacityProviderStrategyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property base Number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined.
 * @property capacityProvider Short name of the capacity provider.
 * @property weight Relative percentage of the total number of launched tasks that should use the specified capacity provider.
 */
public data class ServiceCapacityProviderStrategyArgs(
    public val base: Output<Int>? = null,
    public val capacityProvider: Output<String>,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceCapacityProviderStrategyArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ServiceCapacityProviderStrategyArgs =
        com.pulumi.aws.ecs.inputs.ServiceCapacityProviderStrategyArgs.builder()
            .base(base?.applyValue({ args0 -> args0 }))
            .capacityProvider(capacityProvider.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceCapacityProviderStrategyArgs].
 */
@PulumiTagMarker
public class ServiceCapacityProviderStrategyArgsBuilder internal constructor() {
    private var base: Output<Int>? = null

    private var capacityProvider: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value Number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined.
     */
    @JvmName("xtbleajbxecrasyq")
    public suspend fun base(`value`: Output<Int>) {
        this.base = value
    }

    /**
     * @param value Short name of the capacity provider.
     */
    @JvmName("ujfymqyxlioijtng")
    public suspend fun capacityProvider(`value`: Output<String>) {
        this.capacityProvider = value
    }

    /**
     * @param value Relative percentage of the total number of launched tasks that should use the specified capacity provider.
     */
    @JvmName("lamfdmdkoyobjrld")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value Number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined.
     */
    @JvmName("owfxrkyhumnitxph")
    public suspend fun base(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.base = mapped
    }

    /**
     * @param value Short name of the capacity provider.
     */
    @JvmName("yvhcgnayhujmfwmx")
    public suspend fun capacityProvider(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacityProvider = mapped
    }

    /**
     * @param value Relative percentage of the total number of launched tasks that should use the specified capacity provider.
     */
    @JvmName("hqohwkeewwmjshmq")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): ServiceCapacityProviderStrategyArgs = ServiceCapacityProviderStrategyArgs(
        base = base,
        capacityProvider = capacityProvider ?: throw PulumiNullFieldException("capacityProvider"),
        weight = weight,
    )
}
