@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceDeploymentCircuitBreakerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enable Whether to enable the deployment circuit breaker logic for the service.
 * @property rollback Whether to enable Amazon ECS to roll back the service if a service deployment fails. If rollback is enabled, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
 */
public data class ServiceDeploymentCircuitBreakerArgs(
    public val enable: Output<Boolean>,
    public val rollback: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceDeploymentCircuitBreakerArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ServiceDeploymentCircuitBreakerArgs =
        com.pulumi.aws.ecs.inputs.ServiceDeploymentCircuitBreakerArgs.builder()
            .enable(enable.applyValue({ args0 -> args0 }))
            .rollback(rollback.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceDeploymentCircuitBreakerArgs].
 */
@PulumiTagMarker
public class ServiceDeploymentCircuitBreakerArgsBuilder internal constructor() {
    private var enable: Output<Boolean>? = null

    private var rollback: Output<Boolean>? = null

    /**
     * @param value Whether to enable the deployment circuit breaker logic for the service.
     */
    @JvmName("xmvokggettnwrwkh")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Whether to enable Amazon ECS to roll back the service if a service deployment fails. If rollback is enabled, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
     */
    @JvmName("jahyhxcmcobkvteu")
    public suspend fun rollback(`value`: Output<Boolean>) {
        this.rollback = value
    }

    /**
     * @param value Whether to enable the deployment circuit breaker logic for the service.
     */
    @JvmName("xytorophwwqgdvct")
    public suspend fun enable(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Whether to enable Amazon ECS to roll back the service if a service deployment fails. If rollback is enabled, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
     */
    @JvmName("kugyixgdwyfodlmj")
    public suspend fun rollback(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rollback = mapped
    }

    internal fun build(): ServiceDeploymentCircuitBreakerArgs = ServiceDeploymentCircuitBreakerArgs(
        enable = enable ?: throw PulumiNullFieldException("enable"),
        rollback = rollback ?: throw PulumiNullFieldException("rollback"),
    )
}
