@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceDeploymentControllerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type Type of deployment controller. Valid values: `CODE_DEPLOY`, `ECS`, `EXTERNAL`. Default: `ECS`.
 */
public data class ServiceDeploymentControllerArgs(
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceDeploymentControllerArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ServiceDeploymentControllerArgs =
        com.pulumi.aws.ecs.inputs.ServiceDeploymentControllerArgs.builder()
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceDeploymentControllerArgs].
 */
@PulumiTagMarker
public class ServiceDeploymentControllerArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value Type of deployment controller. Valid values: `CODE_DEPLOY`, `ECS`, `EXTERNAL`. Default: `ECS`.
     */
    @JvmName("jdklwxkfwembtygd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Type of deployment controller. Valid values: `CODE_DEPLOY`, `ECS`, `EXTERNAL`. Default: `ECS`.
     */
    @JvmName("anutulfqcqybkmak")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServiceDeploymentControllerArgs = ServiceDeploymentControllerArgs(
        type = type,
    )
}
