@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServicePlacementConstraintArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expression Cluster Query Language expression to apply to the constraint. Does not need to be specified for the `distinctInstance` type. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
 * @property type Type of constraint. The only valid values at this time are `memberOf` and `distinctInstance`.
 */
public data class ServicePlacementConstraintArgs(
    public val expression: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServicePlacementConstraintArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ServicePlacementConstraintArgs =
        com.pulumi.aws.ecs.inputs.ServicePlacementConstraintArgs.builder()
            .expression(expression?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServicePlacementConstraintArgs].
 */
@PulumiTagMarker
public class ServicePlacementConstraintArgsBuilder internal constructor() {
    private var expression: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Cluster Query Language expression to apply to the constraint. Does not need to be specified for the `distinctInstance` type. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
     */
    @JvmName("ifqjkrajufnnsetq")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value Type of constraint. The only valid values at this time are `memberOf` and `distinctInstance`.
     */
    @JvmName("rbljgrlbxbblbjjw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Cluster Query Language expression to apply to the constraint. Does not need to be specified for the `distinctInstance` type. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
     */
    @JvmName("qsftpofvlslnhbic")
    public suspend fun expression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    /**
     * @param value Type of constraint. The only valid values at this time are `memberOf` and `distinctInstance`.
     */
    @JvmName("gfyippvqhfidrpqp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServicePlacementConstraintArgs = ServicePlacementConstraintArgs(
        expression = expression,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
