@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property clientAlias List of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
 * @property discoveryName Name of the new AWS Cloud Map service that Amazon ECS creates for this Amazon ECS service.
 * @property ingressPortOverride Port number for the Service Connect proxy to listen on.
 * @property portName Name of one of the `portMappings` from all the containers in the task definition of this Amazon ECS service.
 * @property timeout Configuration timeouts for Service Connect
 * @property tls Configuration for enabling Transport Layer Security (TLS)
 */
public data class ServiceServiceConnectConfigurationServiceArgs(
    public val clientAlias: Output<List<ServiceServiceConnectConfigurationServiceClientAliasArgs>>? =
        null,
    public val discoveryName: Output<String>? = null,
    public val ingressPortOverride: Output<Int>? = null,
    public val portName: Output<String>,
    public val timeout: Output<ServiceServiceConnectConfigurationServiceTimeoutArgs>? = null,
    public val tls: Output<ServiceServiceConnectConfigurationServiceTlsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceArgs =
        com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceArgs.builder()
            .clientAlias(
                clientAlias?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .discoveryName(discoveryName?.applyValue({ args0 -> args0 }))
            .ingressPortOverride(ingressPortOverride?.applyValue({ args0 -> args0 }))
            .portName(portName.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tls(tls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ServiceServiceConnectConfigurationServiceArgs].
 */
@PulumiTagMarker
public class ServiceServiceConnectConfigurationServiceArgsBuilder internal constructor() {
    private var clientAlias: Output<List<ServiceServiceConnectConfigurationServiceClientAliasArgs>>? =
        null

    private var discoveryName: Output<String>? = null

    private var ingressPortOverride: Output<Int>? = null

    private var portName: Output<String>? = null

    private var timeout: Output<ServiceServiceConnectConfigurationServiceTimeoutArgs>? = null

    private var tls: Output<ServiceServiceConnectConfigurationServiceTlsArgs>? = null

    /**
     * @param value List of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
     */
    @JvmName("gscaciumeoovftiy")
    public suspend fun clientAlias(`value`: Output<List<ServiceServiceConnectConfigurationServiceClientAliasArgs>>) {
        this.clientAlias = value
    }

    @JvmName("phadsvvcmlmvhdow")
    public suspend fun clientAlias(vararg values: Output<ServiceServiceConnectConfigurationServiceClientAliasArgs>) {
        this.clientAlias = Output.all(values.asList())
    }

    /**
     * @param values List of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
     */
    @JvmName("hmxfrbtymyecnsaa")
    public suspend fun clientAlias(values: List<Output<ServiceServiceConnectConfigurationServiceClientAliasArgs>>) {
        this.clientAlias = Output.all(values)
    }

    /**
     * @param value Name of the new AWS Cloud Map service that Amazon ECS creates for this Amazon ECS service.
     */
    @JvmName("pbffhfvktdcrxvxb")
    public suspend fun discoveryName(`value`: Output<String>) {
        this.discoveryName = value
    }

    /**
     * @param value Port number for the Service Connect proxy to listen on.
     */
    @JvmName("ptouclflwgiknlxo")
    public suspend fun ingressPortOverride(`value`: Output<Int>) {
        this.ingressPortOverride = value
    }

    /**
     * @param value Name of one of the `portMappings` from all the containers in the task definition of this Amazon ECS service.
     */
    @JvmName("tkrgrnlirasljqma")
    public suspend fun portName(`value`: Output<String>) {
        this.portName = value
    }

    /**
     * @param value Configuration timeouts for Service Connect
     */
    @JvmName("kvpwyrdpxjfyiyua")
    public suspend fun timeout(`value`: Output<ServiceServiceConnectConfigurationServiceTimeoutArgs>) {
        this.timeout = value
    }

    /**
     * @param value Configuration for enabling Transport Layer Security (TLS)
     */
    @JvmName("tdjchcioyiwmghqu")
    public suspend fun tls(`value`: Output<ServiceServiceConnectConfigurationServiceTlsArgs>) {
        this.tls = value
    }

    /**
     * @param value List of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
     */
    @JvmName("porcmcqmthhlvfks")
    public suspend fun clientAlias(`value`: List<ServiceServiceConnectConfigurationServiceClientAliasArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAlias = mapped
    }

    /**
     * @param argument List of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
     */
    @JvmName("quuinpjkwsglbxra")
    public suspend fun clientAlias(argument: List<suspend ServiceServiceConnectConfigurationServiceClientAliasArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceServiceConnectConfigurationServiceClientAliasArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.clientAlias = mapped
    }

    /**
     * @param argument List of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
     */
    @JvmName("lhxvulllmgadssie")
    public suspend fun clientAlias(vararg argument: suspend ServiceServiceConnectConfigurationServiceClientAliasArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServiceServiceConnectConfigurationServiceClientAliasArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.clientAlias = mapped
    }

    /**
     * @param argument List of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
     */
    @JvmName("ifslotmiyconoavi")
    public suspend fun clientAlias(argument: suspend ServiceServiceConnectConfigurationServiceClientAliasArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ServiceServiceConnectConfigurationServiceClientAliasArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.clientAlias = mapped
    }

    /**
     * @param values List of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
     */
    @JvmName("yhjxdgfjpdsexfkj")
    public suspend fun clientAlias(vararg values: ServiceServiceConnectConfigurationServiceClientAliasArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientAlias = mapped
    }

    /**
     * @param value Name of the new AWS Cloud Map service that Amazon ECS creates for this Amazon ECS service.
     */
    @JvmName("jlmraqwmnwtnaaga")
    public suspend fun discoveryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoveryName = mapped
    }

    /**
     * @param value Port number for the Service Connect proxy to listen on.
     */
    @JvmName("otetophbrywoktae")
    public suspend fun ingressPortOverride(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingressPortOverride = mapped
    }

    /**
     * @param value Name of one of the `portMappings` from all the containers in the task definition of this Amazon ECS service.
     */
    @JvmName("fwsovqsbpssuhvge")
    public suspend fun portName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portName = mapped
    }

    /**
     * @param value Configuration timeouts for Service Connect
     */
    @JvmName("aasldakvasnlgbaa")
    public suspend fun timeout(`value`: ServiceServiceConnectConfigurationServiceTimeoutArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param argument Configuration timeouts for Service Connect
     */
    @JvmName("tgmmeaspqclwqqfj")
    public suspend fun timeout(argument: suspend ServiceServiceConnectConfigurationServiceTimeoutArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceServiceConnectConfigurationServiceTimeoutArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.timeout = mapped
    }

    /**
     * @param value Configuration for enabling Transport Layer Security (TLS)
     */
    @JvmName("sjbugjbhjodwlrnm")
    public suspend fun tls(`value`: ServiceServiceConnectConfigurationServiceTlsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tls = mapped
    }

    /**
     * @param argument Configuration for enabling Transport Layer Security (TLS)
     */
    @JvmName("canvoraufyomoyyf")
    public suspend fun tls(argument: suspend ServiceServiceConnectConfigurationServiceTlsArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceServiceConnectConfigurationServiceTlsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tls = mapped
    }

    internal fun build(): ServiceServiceConnectConfigurationServiceArgs =
        ServiceServiceConnectConfigurationServiceArgs(
            clientAlias = clientAlias,
            discoveryName = discoveryName,
            ingressPortOverride = ingressPortOverride,
            portName = portName ?: throw PulumiNullFieldException("portName"),
            timeout = timeout,
            tls = tls,
        )
}
