@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceTimeoutArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property idleTimeoutSeconds Amount of time in seconds a connection will stay active while idle. A value of 0 can be set to disable idleTimeout.
 * @property perRequestTimeoutSeconds Amount of time in seconds for the upstream to respond with a complete response per request. A value of 0 can be set to disable perRequestTimeout. Can only be set when appProtocol isn't TCP.
 */
public data class ServiceServiceConnectConfigurationServiceTimeoutArgs(
    public val idleTimeoutSeconds: Output<Int>? = null,
    public val perRequestTimeoutSeconds: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceTimeoutArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceTimeoutArgs =
        com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceTimeoutArgs.builder()
            .idleTimeoutSeconds(idleTimeoutSeconds?.applyValue({ args0 -> args0 }))
            .perRequestTimeoutSeconds(perRequestTimeoutSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceServiceConnectConfigurationServiceTimeoutArgs].
 */
@PulumiTagMarker
public class ServiceServiceConnectConfigurationServiceTimeoutArgsBuilder internal constructor() {
    private var idleTimeoutSeconds: Output<Int>? = null

    private var perRequestTimeoutSeconds: Output<Int>? = null

    /**
     * @param value Amount of time in seconds a connection will stay active while idle. A value of 0 can be set to disable idleTimeout.
     */
    @JvmName("fskfqqtyhmqugdbv")
    public suspend fun idleTimeoutSeconds(`value`: Output<Int>) {
        this.idleTimeoutSeconds = value
    }

    /**
     * @param value Amount of time in seconds for the upstream to respond with a complete response per request. A value of 0 can be set to disable perRequestTimeout. Can only be set when appProtocol isn't TCP.
     */
    @JvmName("ylhwxsrkjpsgoeyc")
    public suspend fun perRequestTimeoutSeconds(`value`: Output<Int>) {
        this.perRequestTimeoutSeconds = value
    }

    /**
     * @param value Amount of time in seconds a connection will stay active while idle. A value of 0 can be set to disable idleTimeout.
     */
    @JvmName("ovdxkvpoulyxnfdl")
    public suspend fun idleTimeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeoutSeconds = mapped
    }

    /**
     * @param value Amount of time in seconds for the upstream to respond with a complete response per request. A value of 0 can be set to disable perRequestTimeout. Can only be set when appProtocol isn't TCP.
     */
    @JvmName("xomhecglteoacpmt")
    public suspend fun perRequestTimeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perRequestTimeoutSeconds = mapped
    }

    internal fun build(): ServiceServiceConnectConfigurationServiceTimeoutArgs =
        ServiceServiceConnectConfigurationServiceTimeoutArgs(
            idleTimeoutSeconds = idleTimeoutSeconds,
            perRequestTimeoutSeconds = perRequestTimeoutSeconds,
        )
}
