@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceTlsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property issuerCertAuthority Details of the certificate authority which will issue the certificate.
 * @property kmsKey KMS key used to encrypt the private key in Secrets Manager.
 * @property roleArn ARN of the IAM Role that's associated with the Service Connect TLS.
 */
public data class ServiceServiceConnectConfigurationServiceTlsArgs(
    public val issuerCertAuthority: Output<ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthorityArgs>,
    public val kmsKey: Output<String>? = null,
    public val roleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceTlsArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceTlsArgs = com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceTlsArgs.builder()
        .issuerCertAuthority(
            issuerCertAuthority.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .kmsKey(kmsKey?.applyValue({ args0 -> args0 }))
        .roleArn(roleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceServiceConnectConfigurationServiceTlsArgs].
 */
@PulumiTagMarker
public class ServiceServiceConnectConfigurationServiceTlsArgsBuilder internal constructor() {
    private var issuerCertAuthority:
        Output<ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthorityArgs>? = null

    private var kmsKey: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value Details of the certificate authority which will issue the certificate.
     */
    @JvmName("yftnxvjtnnwwvbsm")
    public suspend fun issuerCertAuthority(`value`: Output<ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthorityArgs>) {
        this.issuerCertAuthority = value
    }

    /**
     * @param value KMS key used to encrypt the private key in Secrets Manager.
     */
    @JvmName("nbjumtnuqnofefbm")
    public suspend fun kmsKey(`value`: Output<String>) {
        this.kmsKey = value
    }

    /**
     * @param value ARN of the IAM Role that's associated with the Service Connect TLS.
     */
    @JvmName("nmofliwfwqovctug")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Details of the certificate authority which will issue the certificate.
     */
    @JvmName("poengqpxggdojqtj")
    public suspend fun issuerCertAuthority(`value`: ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthorityArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.issuerCertAuthority = mapped
    }

    /**
     * @param argument Details of the certificate authority which will issue the certificate.
     */
    @JvmName("otocoumroxtpxxat")
    public suspend fun issuerCertAuthority(argument: suspend ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthorityArgsBuilder.() -> Unit) {
        val toBeMapped =
            ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthorityArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.issuerCertAuthority = mapped
    }

    /**
     * @param value KMS key used to encrypt the private key in Secrets Manager.
     */
    @JvmName("pwbvndyxmepugdmi")
    public suspend fun kmsKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKey = mapped
    }

    /**
     * @param value ARN of the IAM Role that's associated with the Service Connect TLS.
     */
    @JvmName("orjinapgtiexefud")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): ServiceServiceConnectConfigurationServiceTlsArgs =
        ServiceServiceConnectConfigurationServiceTlsArgs(
            issuerCertAuthority = issuerCertAuthority ?: throw PulumiNullFieldException("issuerCertAuthority"),
            kmsKey = kmsKey,
            roleArn = roleArn,
        )
}
