@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthorityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property awsPcaAuthorityArn ARN of the `aws.acmpca.CertificateAuthority` used to create the TLS Certificates.
 */
public data class ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthorityArgs(
    public val awsPcaAuthorityArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthorityArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthorityArgs =
        com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthorityArgs.builder()
            .awsPcaAuthorityArn(awsPcaAuthorityArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthorityArgs].
 */
@PulumiTagMarker
public class ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthorityArgsBuilder internal constructor() {
    private var awsPcaAuthorityArn: Output<String>? = null

    /**
     * @param value ARN of the `aws.acmpca.CertificateAuthority` used to create the TLS Certificates.
     */
    @JvmName("fgygmnvppmlheise")
    public suspend fun awsPcaAuthorityArn(`value`: Output<String>) {
        this.awsPcaAuthorityArn = value
    }

    /**
     * @param value ARN of the `aws.acmpca.CertificateAuthority` used to create the TLS Certificates.
     */
    @JvmName("fnhbelwodnidxhve")
    public suspend fun awsPcaAuthorityArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.awsPcaAuthorityArn = mapped
    }

    internal fun build(): ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthorityArgs =
        ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthorityArgs(
            awsPcaAuthorityArn = awsPcaAuthorityArn ?: throw PulumiNullFieldException("awsPcaAuthorityArn"),
        )
}
