@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceServiceRegistriesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containerName Container name value, already specified in the task definition, to be used for your service discovery service.
 * @property containerPort Port value, already specified in the task definition, to be used for your service discovery service.
 * @property port Port value used if your Service Discovery service specified an SRV record.
 * @property registryArn ARN of the Service Registry. The currently supported service registry is Amazon Route 53 Auto Naming Service(`aws.servicediscovery.Service`). For more information, see [Service](https://docs.aws.amazon.com/Route53/latest/APIReference/API_autonaming_Service.html)
 */
public data class ServiceServiceRegistriesArgs(
    public val containerName: Output<String>? = null,
    public val containerPort: Output<Int>? = null,
    public val port: Output<Int>? = null,
    public val registryArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceServiceRegistriesArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ServiceServiceRegistriesArgs =
        com.pulumi.aws.ecs.inputs.ServiceServiceRegistriesArgs.builder()
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .containerPort(containerPort?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .registryArn(registryArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceServiceRegistriesArgs].
 */
@PulumiTagMarker
public class ServiceServiceRegistriesArgsBuilder internal constructor() {
    private var containerName: Output<String>? = null

    private var containerPort: Output<Int>? = null

    private var port: Output<Int>? = null

    private var registryArn: Output<String>? = null

    /**
     * @param value Container name value, already specified in the task definition, to be used for your service discovery service.
     */
    @JvmName("fabnuvjfiwjwfrcx")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Port value, already specified in the task definition, to be used for your service discovery service.
     */
    @JvmName("xgliwcepgatcwlad")
    public suspend fun containerPort(`value`: Output<Int>) {
        this.containerPort = value
    }

    /**
     * @param value Port value used if your Service Discovery service specified an SRV record.
     */
    @JvmName("ufyvwjfasuwomtgk")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value ARN of the Service Registry. The currently supported service registry is Amazon Route 53 Auto Naming Service(`aws.servicediscovery.Service`). For more information, see [Service](https://docs.aws.amazon.com/Route53/latest/APIReference/API_autonaming_Service.html)
     */
    @JvmName("maygwrxlbhbojqib")
    public suspend fun registryArn(`value`: Output<String>) {
        this.registryArn = value
    }

    /**
     * @param value Container name value, already specified in the task definition, to be used for your service discovery service.
     */
    @JvmName("aqheafntnafbqwfo")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Port value, already specified in the task definition, to be used for your service discovery service.
     */
    @JvmName("hqrkgensgamggixf")
    public suspend fun containerPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerPort = mapped
    }

    /**
     * @param value Port value used if your Service Discovery service specified an SRV record.
     */
    @JvmName("wdakgbuvfqfkeubx")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value ARN of the Service Registry. The currently supported service registry is Amazon Route 53 Auto Naming Service(`aws.servicediscovery.Service`). For more information, see [Service](https://docs.aws.amazon.com/Route53/latest/APIReference/API_autonaming_Service.html)
     */
    @JvmName("cfvxyshrtlysraeg")
    public suspend fun registryArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.registryArn = mapped
    }

    internal fun build(): ServiceServiceRegistriesArgs = ServiceServiceRegistriesArgs(
        containerName = containerName,
        containerPort = containerPort,
        port = port,
        registryArn = registryArn ?: throw PulumiNullFieldException("registryArn"),
    )
}
