@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceVolumeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property managedEbsVolume Configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. See below.
 * @property name Name of the volume.
 */
public data class ServiceVolumeConfigurationArgs(
    public val managedEbsVolume: Output<ServiceVolumeConfigurationManagedEbsVolumeArgs>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceVolumeConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ServiceVolumeConfigurationArgs =
        com.pulumi.aws.ecs.inputs.ServiceVolumeConfigurationArgs.builder()
            .managedEbsVolume(managedEbsVolume.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceVolumeConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceVolumeConfigurationArgsBuilder internal constructor() {
    private var managedEbsVolume: Output<ServiceVolumeConfigurationManagedEbsVolumeArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value Configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. See below.
     */
    @JvmName("rhdrjeidyamcoucb")
    public suspend fun managedEbsVolume(`value`: Output<ServiceVolumeConfigurationManagedEbsVolumeArgs>) {
        this.managedEbsVolume = value
    }

    /**
     * @param value Name of the volume.
     */
    @JvmName("gpkmsyhgscokdgkc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. See below.
     */
    @JvmName("xxmucmjcmukoipxv")
    public suspend fun managedEbsVolume(`value`: ServiceVolumeConfigurationManagedEbsVolumeArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedEbsVolume = mapped
    }

    /**
     * @param argument Configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. See below.
     */
    @JvmName("wkqwkrtllmlklmku")
    public suspend fun managedEbsVolume(argument: suspend ServiceVolumeConfigurationManagedEbsVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceVolumeConfigurationManagedEbsVolumeArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.managedEbsVolume = mapped
    }

    /**
     * @param value Name of the volume.
     */
    @JvmName("wirxeunkhfeqixmh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ServiceVolumeConfigurationArgs = ServiceVolumeConfigurationArgs(
        managedEbsVolume = managedEbsVolume ?: throw PulumiNullFieldException("managedEbsVolume"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
