@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceVolumeConfigurationManagedEbsVolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property encrypted Whether the volume should be encrypted. Default value is `true`.
 * @property fileSystemType Linux filesystem type for the volume. For volumes created from a snapshot, same filesystem type must be specified that the volume was using when the snapshot was created. Valid values are `ext3`, `ext4`, `xfs`. Default value is `xfs`.
 * @property iops Number of I/O operations per second (IOPS).
 * @property kmsKeyId Amazon Resource Name (ARN) identifier of the Amazon Web Services Key Management Service key to use for Amazon EBS encryption.
 * @property roleArn Amazon ECS infrastructure IAM role that is used to manage your Amazon Web Services infrastructure. Recommended using the Amazon ECS-managed `AmazonECSInfrastructureRolePolicyForVolumes` IAM policy with this role.
 * @property sizeInGb Size of the volume in GiB. You must specify either a `size_in_gb` or a `snapshot_id`. You can optionally specify a volume size greater than or equal to the snapshot size.
 * @property snapshotId Snapshot that Amazon ECS uses to create the volume. You must specify either a `size_in_gb` or a `snapshot_id`.
 * @property throughput Throughput to provision for a volume, in MiB/s, with a maximum of 1,000 MiB/s.
 * @property volumeType Volume type.
 */
public data class ServiceVolumeConfigurationManagedEbsVolumeArgs(
    public val encrypted: Output<Boolean>? = null,
    public val fileSystemType: Output<String>? = null,
    public val iops: Output<Int>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val roleArn: Output<String>,
    public val sizeInGb: Output<Int>? = null,
    public val snapshotId: Output<String>? = null,
    public val throughput: Output<Int>? = null,
    public val volumeType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceVolumeConfigurationManagedEbsVolumeArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.ServiceVolumeConfigurationManagedEbsVolumeArgs =
        com.pulumi.aws.ecs.inputs.ServiceVolumeConfigurationManagedEbsVolumeArgs.builder()
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .fileSystemType(fileSystemType?.applyValue({ args0 -> args0 }))
            .iops(iops?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .sizeInGb(sizeInGb?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 }))
            .throughput(throughput?.applyValue({ args0 -> args0 }))
            .volumeType(volumeType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceVolumeConfigurationManagedEbsVolumeArgs].
 */
@PulumiTagMarker
public class ServiceVolumeConfigurationManagedEbsVolumeArgsBuilder internal constructor() {
    private var encrypted: Output<Boolean>? = null

    private var fileSystemType: Output<String>? = null

    private var iops: Output<Int>? = null

    private var kmsKeyId: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var sizeInGb: Output<Int>? = null

    private var snapshotId: Output<String>? = null

    private var throughput: Output<Int>? = null

    private var volumeType: Output<String>? = null

    /**
     * @param value Whether the volume should be encrypted. Default value is `true`.
     */
    @JvmName("vlxtuuvgrjnapkmh")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value Linux filesystem type for the volume. For volumes created from a snapshot, same filesystem type must be specified that the volume was using when the snapshot was created. Valid values are `ext3`, `ext4`, `xfs`. Default value is `xfs`.
     */
    @JvmName("tkxofcdjyqhylvlm")
    public suspend fun fileSystemType(`value`: Output<String>) {
        this.fileSystemType = value
    }

    /**
     * @param value Number of I/O operations per second (IOPS).
     */
    @JvmName("wuokjcjrfqufonbf")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value Amazon Resource Name (ARN) identifier of the Amazon Web Services Key Management Service key to use for Amazon EBS encryption.
     */
    @JvmName("hptmppoxcoctkbpr")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Amazon ECS infrastructure IAM role that is used to manage your Amazon Web Services infrastructure. Recommended using the Amazon ECS-managed `AmazonECSInfrastructureRolePolicyForVolumes` IAM policy with this role.
     */
    @JvmName("duxsbqgtbjciixeh")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Size of the volume in GiB. You must specify either a `size_in_gb` or a `snapshot_id`. You can optionally specify a volume size greater than or equal to the snapshot size.
     */
    @JvmName("tfykmhvxylafgmkb")
    public suspend fun sizeInGb(`value`: Output<Int>) {
        this.sizeInGb = value
    }

    /**
     * @param value Snapshot that Amazon ECS uses to create the volume. You must specify either a `size_in_gb` or a `snapshot_id`.
     */
    @JvmName("pqnwunymcpyjgyul")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value Throughput to provision for a volume, in MiB/s, with a maximum of 1,000 MiB/s.
     */
    @JvmName("eaqdpndtgjsvkixm")
    public suspend fun throughput(`value`: Output<Int>) {
        this.throughput = value
    }

    /**
     * @param value Volume type.
     */
    @JvmName("hgxbtlejctempeyf")
    public suspend fun volumeType(`value`: Output<String>) {
        this.volumeType = value
    }

    /**
     * @param value Whether the volume should be encrypted. Default value is `true`.
     */
    @JvmName("ecxkpexwwrnpydlx")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value Linux filesystem type for the volume. For volumes created from a snapshot, same filesystem type must be specified that the volume was using when the snapshot was created. Valid values are `ext3`, `ext4`, `xfs`. Default value is `xfs`.
     */
    @JvmName("cbmpiysmbavuawtt")
    public suspend fun fileSystemType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemType = mapped
    }

    /**
     * @param value Number of I/O operations per second (IOPS).
     */
    @JvmName("haqoowrjwvqxighf")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) identifier of the Amazon Web Services Key Management Service key to use for Amazon EBS encryption.
     */
    @JvmName("fdiueeyijeunnvlf")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Amazon ECS infrastructure IAM role that is used to manage your Amazon Web Services infrastructure. Recommended using the Amazon ECS-managed `AmazonECSInfrastructureRolePolicyForVolumes` IAM policy with this role.
     */
    @JvmName("ifsypneijghwqeuh")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Size of the volume in GiB. You must specify either a `size_in_gb` or a `snapshot_id`. You can optionally specify a volume size greater than or equal to the snapshot size.
     */
    @JvmName("frflhmxhaodhyxid")
    public suspend fun sizeInGb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeInGb = mapped
    }

    /**
     * @param value Snapshot that Amazon ECS uses to create the volume. You must specify either a `size_in_gb` or a `snapshot_id`.
     */
    @JvmName("nvccskxfgygcbidt")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    /**
     * @param value Throughput to provision for a volume, in MiB/s, with a maximum of 1,000 MiB/s.
     */
    @JvmName("rkjojbhxmbiyeqvx")
    public suspend fun throughput(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughput = mapped
    }

    /**
     * @param value Volume type.
     */
    @JvmName("pguqnqcgvjhpryqj")
    public suspend fun volumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    internal fun build(): ServiceVolumeConfigurationManagedEbsVolumeArgs =
        ServiceVolumeConfigurationManagedEbsVolumeArgs(
            encrypted = encrypted,
            fileSystemType = fileSystemType,
            iops = iops,
            kmsKeyId = kmsKeyId,
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
            sizeInGb = sizeInGb,
            snapshotId = snapshotId,
            throughput = throughput,
            volumeType = volumeType,
        )
}
