@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.TaskDefinitionEphemeralStorageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property sizeInGib The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `21` GiB and the maximum supported value is `200` GiB.
 */
public data class TaskDefinitionEphemeralStorageArgs(
    public val sizeInGib: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.TaskDefinitionEphemeralStorageArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.TaskDefinitionEphemeralStorageArgs =
        com.pulumi.aws.ecs.inputs.TaskDefinitionEphemeralStorageArgs.builder()
            .sizeInGib(sizeInGib.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskDefinitionEphemeralStorageArgs].
 */
@PulumiTagMarker
public class TaskDefinitionEphemeralStorageArgsBuilder internal constructor() {
    private var sizeInGib: Output<Int>? = null

    /**
     * @param value The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `21` GiB and the maximum supported value is `200` GiB.
     */
    @JvmName("pguqhwalascfrkre")
    public suspend fun sizeInGib(`value`: Output<Int>) {
        this.sizeInGib = value
    }

    /**
     * @param value The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `21` GiB and the maximum supported value is `200` GiB.
     */
    @JvmName("dmobtvgfhakjwpuh")
    public suspend fun sizeInGib(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizeInGib = mapped
    }

    internal fun build(): TaskDefinitionEphemeralStorageArgs = TaskDefinitionEphemeralStorageArgs(
        sizeInGib = sizeInGib ?: throw PulumiNullFieldException("sizeInGib"),
    )
}
