@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeEfsVolumeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationConfig Configuration block for authorization for the Amazon EFS file system. Detailed below.
 * @property fileSystemId ID of the EFS File System.
 * @property rootDirectory Directory within the Amazon EFS file system to mount as the root directory inside the host. If this parameter is omitted, the root of the Amazon EFS volume will be used. Specifying / will have the same effect as omitting this parameter. This argument is ignored when using `authorization_config`.
 * @property transitEncryption Whether or not to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is used. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
 * @property transitEncryptionPort Port to use for transit encryption. If you do not specify a transit encryption port, it will use the port selection strategy that the Amazon EFS mount helper uses.
 */
public data class TaskDefinitionVolumeEfsVolumeConfigurationArgs(
    public val authorizationConfig: Output<TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs>? = null,
    public val fileSystemId: Output<String>,
    public val rootDirectory: Output<String>? = null,
    public val transitEncryption: Output<String>? = null,
    public val transitEncryptionPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeEfsVolumeConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeEfsVolumeConfigurationArgs =
        com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeEfsVolumeConfigurationArgs.builder()
            .authorizationConfig(
                authorizationConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .fileSystemId(fileSystemId.applyValue({ args0 -> args0 }))
            .rootDirectory(rootDirectory?.applyValue({ args0 -> args0 }))
            .transitEncryption(transitEncryption?.applyValue({ args0 -> args0 }))
            .transitEncryptionPort(transitEncryptionPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskDefinitionVolumeEfsVolumeConfigurationArgs].
 */
@PulumiTagMarker
public class TaskDefinitionVolumeEfsVolumeConfigurationArgsBuilder internal constructor() {
    private var authorizationConfig:
        Output<TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs>? = null

    private var fileSystemId: Output<String>? = null

    private var rootDirectory: Output<String>? = null

    private var transitEncryption: Output<String>? = null

    private var transitEncryptionPort: Output<Int>? = null

    /**
     * @param value Configuration block for authorization for the Amazon EFS file system. Detailed below.
     */
    @JvmName("etqxdhgiljxgbpjd")
    public suspend fun authorizationConfig(`value`: Output<TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs>) {
        this.authorizationConfig = value
    }

    /**
     * @param value ID of the EFS File System.
     */
    @JvmName("sdxiqftvxsbjnonb")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value Directory within the Amazon EFS file system to mount as the root directory inside the host. If this parameter is omitted, the root of the Amazon EFS volume will be used. Specifying / will have the same effect as omitting this parameter. This argument is ignored when using `authorization_config`.
     */
    @JvmName("diuoylknkiqwsrbk")
    public suspend fun rootDirectory(`value`: Output<String>) {
        this.rootDirectory = value
    }

    /**
     * @param value Whether or not to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is used. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
     */
    @JvmName("wysgoiyquntekqau")
    public suspend fun transitEncryption(`value`: Output<String>) {
        this.transitEncryption = value
    }

    /**
     * @param value Port to use for transit encryption. If you do not specify a transit encryption port, it will use the port selection strategy that the Amazon EFS mount helper uses.
     */
    @JvmName("kicxroiwfxkhosvp")
    public suspend fun transitEncryptionPort(`value`: Output<Int>) {
        this.transitEncryptionPort = value
    }

    /**
     * @param value Configuration block for authorization for the Amazon EFS file system. Detailed below.
     */
    @JvmName("dberuxrknecjknah")
    public suspend fun authorizationConfig(`value`: TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationConfig = mapped
    }

    /**
     * @param argument Configuration block for authorization for the Amazon EFS file system. Detailed below.
     */
    @JvmName("ugjfgxcuxbtphjpk")
    public suspend fun authorizationConfig(argument: suspend TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.authorizationConfig = mapped
    }

    /**
     * @param value ID of the EFS File System.
     */
    @JvmName("nhmoinijuvgyjtrb")
    public suspend fun fileSystemId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value Directory within the Amazon EFS file system to mount as the root directory inside the host. If this parameter is omitted, the root of the Amazon EFS volume will be used. Specifying / will have the same effect as omitting this parameter. This argument is ignored when using `authorization_config`.
     */
    @JvmName("acgxxvbxnclawwxq")
    public suspend fun rootDirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootDirectory = mapped
    }

    /**
     * @param value Whether or not to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is used. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
     */
    @JvmName("voaifyrtnatynjfk")
    public suspend fun transitEncryption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitEncryption = mapped
    }

    /**
     * @param value Port to use for transit encryption. If you do not specify a transit encryption port, it will use the port selection strategy that the Amazon EFS mount helper uses.
     */
    @JvmName("gfxngalkqdctxchl")
    public suspend fun transitEncryptionPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitEncryptionPort = mapped
    }

    internal fun build(): TaskDefinitionVolumeEfsVolumeConfigurationArgs =
        TaskDefinitionVolumeEfsVolumeConfigurationArgs(
            authorizationConfig = authorizationConfig,
            fileSystemId = fileSystemId ?: throw PulumiNullFieldException("fileSystemId"),
            rootDirectory = rootDirectory,
            transitEncryption = transitEncryption,
            transitEncryptionPort = transitEncryptionPort,
        )
}
