@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property credentialsParameter The authorization credential option to use. The authorization credential options can be provided using either the Amazon Resource Name (ARN) of an AWS Secrets Manager secret or AWS Systems Manager Parameter Store parameter. The ARNs refer to the stored credentials.
 * @property domain A fully qualified domain name hosted by an AWS Directory Service Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
 */
public data class
TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs(
    public val credentialsParameter: Output<String>,
    public val domain: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs =
        com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs.builder()
            .credentialsParameter(credentialsParameter.applyValue({ args0 -> args0 }))
            .domain(domain.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs].
 */
@PulumiTagMarker
public class
TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgsBuilder
internal constructor() {
    private var credentialsParameter: Output<String>? = null

    private var domain: Output<String>? = null

    /**
     * @param value The authorization credential option to use. The authorization credential options can be provided using either the Amazon Resource Name (ARN) of an AWS Secrets Manager secret or AWS Systems Manager Parameter Store parameter. The ARNs refer to the stored credentials.
     */
    @JvmName("fkepuahcalywpapn")
    public suspend fun credentialsParameter(`value`: Output<String>) {
        this.credentialsParameter = value
    }

    /**
     * @param value A fully qualified domain name hosted by an AWS Directory Service Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
     */
    @JvmName("fjywwdvjiahmvyhn")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The authorization credential option to use. The authorization credential options can be provided using either the Amazon Resource Name (ARN) of an AWS Secrets Manager secret or AWS Systems Manager Parameter Store parameter. The ARNs refer to the stored credentials.
     */
    @JvmName("rljwdnjamsayrtry")
    public suspend fun credentialsParameter(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentialsParameter = mapped
    }

    /**
     * @param value A fully qualified domain name hosted by an AWS Directory Service Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
     */
    @JvmName("uxyhnryarrxwvhas")
    public suspend fun domain(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    internal fun build(): TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs =
        TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs(
            credentialsParameter = credentialsParameter ?: throw
                PulumiNullFieldException("credentialsParameter"),
            domain = domain ?: throw PulumiNullFieldException("domain"),
        )
}
