@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.TaskSetCapacityProviderStrategyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property base The number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined.
 * @property capacityProvider The short name or full Amazon Resource Name (ARN) of the capacity provider.
 * @property weight The relative percentage of the total number of launched tasks that should use the specified capacity provider.
 */
public data class TaskSetCapacityProviderStrategyArgs(
    public val base: Output<Int>? = null,
    public val capacityProvider: Output<String>,
    public val weight: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.TaskSetCapacityProviderStrategyArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.TaskSetCapacityProviderStrategyArgs =
        com.pulumi.aws.ecs.inputs.TaskSetCapacityProviderStrategyArgs.builder()
            .base(base?.applyValue({ args0 -> args0 }))
            .capacityProvider(capacityProvider.applyValue({ args0 -> args0 }))
            .weight(weight.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskSetCapacityProviderStrategyArgs].
 */
@PulumiTagMarker
public class TaskSetCapacityProviderStrategyArgsBuilder internal constructor() {
    private var base: Output<Int>? = null

    private var capacityProvider: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined.
     */
    @JvmName("gkvcehpxbehoochp")
    public suspend fun base(`value`: Output<Int>) {
        this.base = value
    }

    /**
     * @param value The short name or full Amazon Resource Name (ARN) of the capacity provider.
     */
    @JvmName("qehwiowhauydyepn")
    public suspend fun capacityProvider(`value`: Output<String>) {
        this.capacityProvider = value
    }

    /**
     * @param value The relative percentage of the total number of launched tasks that should use the specified capacity provider.
     */
    @JvmName("sctiuubsrbkcgcql")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined.
     */
    @JvmName("pxwcftlngqhewayo")
    public suspend fun base(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.base = mapped
    }

    /**
     * @param value The short name or full Amazon Resource Name (ARN) of the capacity provider.
     */
    @JvmName("cxabuaxutsoihacx")
    public suspend fun capacityProvider(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacityProvider = mapped
    }

    /**
     * @param value The relative percentage of the total number of launched tasks that should use the specified capacity provider.
     */
    @JvmName("dywxgiwcqnrxjqmk")
    public suspend fun weight(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): TaskSetCapacityProviderStrategyArgs = TaskSetCapacityProviderStrategyArgs(
        base = base,
        capacityProvider = capacityProvider ?: throw PulumiNullFieldException("capacityProvider"),
        weight = weight ?: throw PulumiNullFieldException("weight"),
    )
}
