@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.TaskSetNetworkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property assignPublicIp Whether to assign a public IP address to the ENI (`FARGATE` launch type only). Valid values are `true` or `false`. Default `false`.
 * For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html).
 * @property securityGroups The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used. Maximum of 5.
 * @property subnets The subnets associated with the task or service. Maximum of 16.
 */
public data class TaskSetNetworkConfigurationArgs(
    public val assignPublicIp: Output<Boolean>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val subnets: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.TaskSetNetworkConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.TaskSetNetworkConfigurationArgs =
        com.pulumi.aws.ecs.inputs.TaskSetNetworkConfigurationArgs.builder()
            .assignPublicIp(assignPublicIp?.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnets(subnets.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [TaskSetNetworkConfigurationArgs].
 */
@PulumiTagMarker
public class TaskSetNetworkConfigurationArgsBuilder internal constructor() {
    private var assignPublicIp: Output<Boolean>? = null

    private var securityGroups: Output<List<String>>? = null

    private var subnets: Output<List<String>>? = null

    /**
     * @param value Whether to assign a public IP address to the ENI (`FARGATE` launch type only). Valid values are `true` or `false`. Default `false`.
     * For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html).
     */
    @JvmName("ebtthdugobxoopvb")
    public suspend fun assignPublicIp(`value`: Output<Boolean>) {
        this.assignPublicIp = value
    }

    /**
     * @param value The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used. Maximum of 5.
     */
    @JvmName("ywpapxccvssxvrdq")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("ltagchiayyfxcmxk")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used. Maximum of 5.
     */
    @JvmName("dbhythasmwugofqc")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value The subnets associated with the task or service. Maximum of 16.
     */
    @JvmName("tqmobuerkeuoxoxy")
    public suspend fun subnets(`value`: Output<List<String>>) {
        this.subnets = value
    }

    @JvmName("bvlburefuvkvarrd")
    public suspend fun subnets(vararg values: Output<String>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values The subnets associated with the task or service. Maximum of 16.
     */
    @JvmName("gworytkduudqvgng")
    public suspend fun subnets(values: List<Output<String>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value Whether to assign a public IP address to the ENI (`FARGATE` launch type only). Valid values are `true` or `false`. Default `false`.
     * For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html).
     */
    @JvmName("hjacfnhslupfbney")
    public suspend fun assignPublicIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignPublicIp = mapped
    }

    /**
     * @param value The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used. Maximum of 5.
     */
    @JvmName("jxjgqxiexqcxfifj")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used. Maximum of 5.
     */
    @JvmName("nokjkxokosqqdjsw")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value The subnets associated with the task or service. Maximum of 16.
     */
    @JvmName("qtpsmqyexkporigq")
    public suspend fun subnets(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param values The subnets associated with the task or service. Maximum of 16.
     */
    @JvmName("sdtdmdkthqchbstx")
    public suspend fun subnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    internal fun build(): TaskSetNetworkConfigurationArgs = TaskSetNetworkConfigurationArgs(
        assignPublicIp = assignPublicIp,
        securityGroups = securityGroups,
        subnets = subnets ?: throw PulumiNullFieldException("subnets"),
    )
}
