@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.TaskSetServiceRegistriesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containerName The container name value, already specified in the task definition, to be used for your service discovery service.
 * @property containerPort The port value, already specified in the task definition, to be used for your service discovery service.
 * @property port The port value used if your Service Discovery service specified an SRV record.
 * @property registryArn The ARN of the Service Registry. The currently supported service registry is Amazon Route 53 Auto Naming Service(`aws.servicediscovery.Service` resource). For more information, see [Service](https://docs.aws.amazon.com/Route53/latest/APIReference/API_autonaming_Service.html).
 */
public data class TaskSetServiceRegistriesArgs(
    public val containerName: Output<String>? = null,
    public val containerPort: Output<Int>? = null,
    public val port: Output<Int>? = null,
    public val registryArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.TaskSetServiceRegistriesArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.TaskSetServiceRegistriesArgs =
        com.pulumi.aws.ecs.inputs.TaskSetServiceRegistriesArgs.builder()
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .containerPort(containerPort?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .registryArn(registryArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskSetServiceRegistriesArgs].
 */
@PulumiTagMarker
public class TaskSetServiceRegistriesArgsBuilder internal constructor() {
    private var containerName: Output<String>? = null

    private var containerPort: Output<Int>? = null

    private var port: Output<Int>? = null

    private var registryArn: Output<String>? = null

    /**
     * @param value The container name value, already specified in the task definition, to be used for your service discovery service.
     */
    @JvmName("ddkivvttasxjccsl")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value The port value, already specified in the task definition, to be used for your service discovery service.
     */
    @JvmName("deeospvwqdumcwqq")
    public suspend fun containerPort(`value`: Output<Int>) {
        this.containerPort = value
    }

    /**
     * @param value The port value used if your Service Discovery service specified an SRV record.
     */
    @JvmName("rpbbgglttjhowvey")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The ARN of the Service Registry. The currently supported service registry is Amazon Route 53 Auto Naming Service(`aws.servicediscovery.Service` resource). For more information, see [Service](https://docs.aws.amazon.com/Route53/latest/APIReference/API_autonaming_Service.html).
     */
    @JvmName("qyyrctmgefooxwsm")
    public suspend fun registryArn(`value`: Output<String>) {
        this.registryArn = value
    }

    /**
     * @param value The container name value, already specified in the task definition, to be used for your service discovery service.
     */
    @JvmName("owcpupfyvtvclvlj")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value The port value, already specified in the task definition, to be used for your service discovery service.
     */
    @JvmName("mupdwdpueadbviyt")
    public suspend fun containerPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerPort = mapped
    }

    /**
     * @param value The port value used if your Service Discovery service specified an SRV record.
     */
    @JvmName("ishodbrtdxuexkjw")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The ARN of the Service Registry. The currently supported service registry is Amazon Route 53 Auto Naming Service(`aws.servicediscovery.Service` resource). For more information, see [Service](https://docs.aws.amazon.com/Route53/latest/APIReference/API_autonaming_Service.html).
     */
    @JvmName("wkjqebqejndclmnd")
    public suspend fun registryArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.registryArn = mapped
    }

    internal fun build(): TaskSetServiceRegistriesArgs = TaskSetServiceRegistriesArgs(
        containerName = containerName,
        containerPort = containerPort,
        port = port,
        registryArn = registryArn ?: throw PulumiNullFieldException("registryArn"),
    )
}
