@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceWarmupPeriod Period of time, in seconds, after a newly launched Amazon EC2 instance can contribute to CloudWatch metrics for Auto Scaling group. If this parameter is omitted, the default value of 300 seconds is used.
 * @property maximumScalingStepSize Maximum step adjustment size. A number between 1 and 10,000.
 * @property minimumScalingStepSize Minimum step adjustment size. A number between 1 and 10,000.
 * @property status Whether auto scaling is managed by ECS. Valid values are `ENABLED` and `DISABLED`.
 * @property targetCapacity Target utilization for the capacity provider. A number between 1 and 100.
 */
public data class CapacityProviderAutoScalingGroupProviderManagedScaling(
    public val instanceWarmupPeriod: Int? = null,
    public val maximumScalingStepSize: Int? = null,
    public val minimumScalingStepSize: Int? = null,
    public val status: String? = null,
    public val targetCapacity: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.CapacityProviderAutoScalingGroupProviderManagedScaling): CapacityProviderAutoScalingGroupProviderManagedScaling =
            CapacityProviderAutoScalingGroupProviderManagedScaling(
                instanceWarmupPeriod = javaType.instanceWarmupPeriod().map({ args0 -> args0 }).orElse(null),
                maximumScalingStepSize = javaType.maximumScalingStepSize().map({ args0 -> args0 }).orElse(null),
                minimumScalingStepSize = javaType.minimumScalingStepSize().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
                targetCapacity = javaType.targetCapacity().map({ args0 -> args0 }).orElse(null),
            )
    }
}
