@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property executeCommandConfiguration Details of the execute command configuration. See `execute_command_configuration` Block for details.
 * @property managedStorageConfiguration Details of the managed storage configuration. See `managed_storage_configuration` Block for details.
 */
public data class ClusterConfiguration(
    public val executeCommandConfiguration: ClusterConfigurationExecuteCommandConfiguration? = null,
    public val managedStorageConfiguration: ClusterConfigurationManagedStorageConfiguration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.ClusterConfiguration): ClusterConfiguration = ClusterConfiguration(
            executeCommandConfiguration = javaType.executeCommandConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.ClusterConfigurationExecuteCommandConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            managedStorageConfiguration = javaType.managedStorageConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.ClusterConfigurationManagedStorageConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
