@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyId AWS Key Management Service key ID to encrypt the data between the local client and the container.
 * @property logConfiguration Log configuration for the results of the execute command actions. Required when `logging` is `OVERRIDE`. See `log_configuration` Block for details.
 * @property logging Log setting to use for redirecting logs for your execute command results. Valid values: `NONE`, `DEFAULT`, `OVERRIDE`.
 */
public data class ClusterConfigurationExecuteCommandConfiguration(
    public val kmsKeyId: String? = null,
    public val logConfiguration: ClusterConfigurationExecuteCommandConfigurationLogConfiguration? =
        null,
    public val logging: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.ClusterConfigurationExecuteCommandConfiguration): ClusterConfigurationExecuteCommandConfiguration =
            ClusterConfigurationExecuteCommandConfiguration(
                kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
                logConfiguration = javaType.logConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ecs.kotlin.outputs.ClusterConfigurationExecuteCommandConfigurationLogConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                logging = javaType.logging().map({ args0 -> args0 }).orElse(null),
            )
    }
}
