@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fargateEphemeralStorageKmsKeyId AWS Key Management Service key ID for the Fargate ephemeral storage.
 * @property kmsKeyId AWS Key Management Service key ID to encrypt the managed storage.
 */
public data class ClusterConfigurationManagedStorageConfiguration(
    public val fargateEphemeralStorageKmsKeyId: String? = null,
    public val kmsKeyId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.ClusterConfigurationManagedStorageConfiguration): ClusterConfigurationManagedStorageConfiguration =
            ClusterConfigurationManagedStorageConfiguration(
                fargateEphemeralStorageKmsKeyId = javaType.fargateEphemeralStorageKmsKeyId().map({ args0 ->
                    args0
                }).orElse(null),
                kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
