@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getCluster.
 * @property arn ARN of the ECS Cluster
 * @property clusterName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property pendingTasksCount Number of pending tasks for the ECS Cluster
 * @property registeredContainerInstancesCount The number of registered container instances for the ECS Cluster
 * @property runningTasksCount Number of running tasks for the ECS Cluster
 * @property serviceConnectDefaults The default Service Connect namespace
 * @property settings Settings associated with the ECS Cluster
 * @property status Status of the ECS Cluster
 * @property tags Key-value map of resource tags
 */
public data class GetClusterResult(
    public val arn: String,
    public val clusterName: String,
    public val id: String,
    public val pendingTasksCount: Int,
    public val registeredContainerInstancesCount: Int,
    public val runningTasksCount: Int,
    public val serviceConnectDefaults: List<GetClusterServiceConnectDefault>,
    public val settings: List<GetClusterSetting>,
    public val status: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.GetClusterResult): GetClusterResult =
            GetClusterResult(
                arn = javaType.arn(),
                clusterName = javaType.clusterName(),
                id = javaType.id(),
                pendingTasksCount = javaType.pendingTasksCount(),
                registeredContainerInstancesCount = javaType.registeredContainerInstancesCount(),
                runningTasksCount = javaType.runningTasksCount(),
                serviceConnectDefaults = javaType.serviceConnectDefaults().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ecs.kotlin.outputs.GetClusterServiceConnectDefault.Companion.toKotlin(args0)
                    })
                }),
                settings = javaType.settings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ecs.kotlin.outputs.GetClusterSetting.Companion.toKotlin(args0)
                    })
                }),
                status = javaType.status(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
