@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getContainerDefinition.
 * @property containerName
 * @property cpu CPU limit for this container definition
 * @property disableNetworking Indicator if networking is disabled
 * @property dockerLabels Set docker labels
 * @property environment Environment in use
 * @property id The provider-assigned unique ID for this managed resource.
 * @property image Docker image in use, including the digest
 * @property imageDigest Digest of the docker image in use
 * @property memory Memory limit for this container definition
 * @property memoryReservation Soft limit (in MiB) of memory to reserve for the container. When system memory is under contention, Docker attempts to keep the container memory to this soft limit
 * @property taskDefinition
 */
public data class GetContainerDefinitionResult(
    public val containerName: String,
    public val cpu: Int,
    public val disableNetworking: Boolean,
    public val dockerLabels: Map<String, String>,
    public val environment: Map<String, String>,
    public val id: String,
    public val image: String,
    public val imageDigest: String,
    public val memory: Int,
    public val memoryReservation: Int,
    public val taskDefinition: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.GetContainerDefinitionResult): GetContainerDefinitionResult = GetContainerDefinitionResult(
            containerName = javaType.containerName(),
            cpu = javaType.cpu(),
            disableNetworking = javaType.disableNetworking(),
            dockerLabels = javaType.dockerLabels().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            environment = javaType.environment().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            id = javaType.id(),
            image = javaType.image(),
            imageDigest = javaType.imageDigest(),
            memory = javaType.memory(),
            memoryReservation = javaType.memoryReservation(),
            taskDefinition = javaType.taskDefinition(),
        )
    }
}
