@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getService.
 * @property arn ARN of the ECS Service
 * @property clusterArn
 * @property desiredCount Number of tasks for the ECS Service
 * @property id The provider-assigned unique ID for this managed resource.
 * @property launchType Launch type for the ECS Service
 * @property schedulingStrategy Scheduling strategy for the ECS Service
 * @property serviceName
 * @property tags Resource tags.
 * @property taskDefinition Family for the latest ACTIVE revision or full ARN of the task definition.
 */
public data class GetServiceResult(
    public val arn: String,
    public val clusterArn: String,
    public val desiredCount: Int,
    public val id: String,
    public val launchType: String,
    public val schedulingStrategy: String,
    public val serviceName: String,
    public val tags: Map<String, String>,
    public val taskDefinition: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.GetServiceResult): GetServiceResult =
            GetServiceResult(
                arn = javaType.arn(),
                clusterArn = javaType.clusterArn(),
                desiredCount = javaType.desiredCount(),
                id = javaType.id(),
                launchType = javaType.launchType(),
                schedulingStrategy = javaType.schedulingStrategy(),
                serviceName = javaType.serviceName(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                taskDefinition = javaType.taskDefinition(),
            )
    }
}
