@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getTaskDefinition.
 * @property arn ARN of the task definition.
 * @property arnWithoutRevision ARN of the Task Definition with the trailing `revision` removed. This may be useful for situations where the latest task definition is always desired. If a revision isn't specified, the latest ACTIVE revision is used. See the [AWS documentation](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_StartTask.html#ECS-StartTask-request-taskDefinition) for details.
 * @property executionRoleArn ARN of the task execution role that the Amazon ECS container agent and the Docker.
 * @property family Family of this task definition.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property networkMode Docker networking mode to use for the containers in this task.
 * @property revision Revision of this task definition.
 * @property status Status of this task definition.
 * @property taskDefinition
 * @property taskRoleArn ARN of the IAM role that containers in this task can assume.
 */
public data class GetTaskDefinitionResult(
    public val arn: String,
    public val arnWithoutRevision: String,
    public val executionRoleArn: String,
    public val family: String,
    public val id: String,
    public val networkMode: String,
    public val revision: Int,
    public val status: String,
    public val taskDefinition: String,
    public val taskRoleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.GetTaskDefinitionResult): GetTaskDefinitionResult = GetTaskDefinitionResult(
            arn = javaType.arn(),
            arnWithoutRevision = javaType.arnWithoutRevision(),
            executionRoleArn = javaType.executionRoleArn(),
            family = javaType.family(),
            id = javaType.id(),
            networkMode = javaType.networkMode(),
            revision = javaType.revision(),
            status = javaType.status(),
            taskDefinition = javaType.taskDefinition(),
            taskRoleArn = javaType.taskRoleArn(),
        )
    }
}
