@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property commands The command to send to the container that overrides the default command from the Docker image or the task definition.
 * @property cpu The number of cpu units reserved for the container, instead of the default value from the task definition.
 * @property environments The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. See below.
 * @property memory The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed.
 * @property memoryReservation The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition.
 * @property name The name of the container that receives the override. This parameter is required if any override is specified.
 * @property resourceRequirements The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. See below.
 */
public data class GetTaskExecutionOverridesContainerOverride(
    public val commands: List<String>? = null,
    public val cpu: Int? = null,
    public val environments: List<GetTaskExecutionOverridesContainerOverrideEnvironment>? = null,
    public val memory: Int? = null,
    public val memoryReservation: Int? = null,
    public val name: String,
    public val resourceRequirements: List<GetTaskExecutionOverridesContainerOverrideResourceRequirement>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.GetTaskExecutionOverridesContainerOverride): GetTaskExecutionOverridesContainerOverride = GetTaskExecutionOverridesContainerOverride(
            commands = javaType.commands().map({ args0 -> args0 }),
            cpu = javaType.cpu().map({ args0 -> args0 }).orElse(null),
            environments = javaType.environments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.GetTaskExecutionOverridesContainerOverrideEnvironment.Companion.toKotlin(args0)
                })
            }),
            memory = javaType.memory().map({ args0 -> args0 }).orElse(null),
            memoryReservation = javaType.memoryReservation().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            resourceRequirements = javaType.resourceRequirements().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.GetTaskExecutionOverridesContainerOverrideResourceRequirement.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
