@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property type The type of resource to assign to a container. Valid values are `GPU` or `InferenceAccelerator`.
 * @property value The value for the specified resource type. If the `GPU` type is used, the value is the number of physical GPUs the Amazon ECS container agent reserves for the container. The number of GPUs that's reserved for all containers in a task can't exceed the number of available GPUs on the container instance that the task is launched on. If the `InferenceAccelerator` type is used, the value matches the `deviceName` for an InferenceAccelerator specified in a task definition.
 */
public data class GetTaskExecutionOverridesContainerOverrideResourceRequirement(
    public val type: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.GetTaskExecutionOverridesContainerOverrideResourceRequirement): GetTaskExecutionOverridesContainerOverrideResourceRequirement =
            GetTaskExecutionOverridesContainerOverrideResourceRequirement(
                type = javaType.type(),
                `value` = javaType.`value`(),
            )
    }
}
