@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property expression A cluster query language expression to apply to the constraint. The expression can have a maximum length of 2000 characters. You can't specify an expression if the constraint type is `distinctInstance`.
 * @property type The type of constraint. Valid values are `distinctInstance` or `memberOf`. Use `distinctInstance` to ensure that each task in a particular group is running on a different container instance. Use `memberOf` to restrict the selection to a group of valid candidates.
 */
public data class GetTaskExecutionPlacementConstraint(
    public val expression: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.GetTaskExecutionPlacementConstraint): GetTaskExecutionPlacementConstraint = GetTaskExecutionPlacementConstraint(
            expression = javaType.expression().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
