@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getTaskExecution.
 * @property capacityProviderStrategies
 * @property clientToken
 * @property cluster
 * @property desiredCount
 * @property enableEcsManagedTags
 * @property enableExecuteCommand
 * @property group
 * @property id The provider-assigned unique ID for this managed resource.
 * @property launchType
 * @property networkConfiguration
 * @property overrides
 * @property placementConstraints
 * @property placementStrategies
 * @property platformVersion
 * @property propagateTags
 * @property referenceId
 * @property startedBy
 * @property tags
 * @property taskArns A list of the provisioned task ARNs.
 * @property taskDefinition
 */
public data class GetTaskExecutionResult(
    public val capacityProviderStrategies: List<GetTaskExecutionCapacityProviderStrategy>? = null,
    public val clientToken: String? = null,
    public val cluster: String,
    public val desiredCount: Int? = null,
    public val enableEcsManagedTags: Boolean? = null,
    public val enableExecuteCommand: Boolean? = null,
    public val group: String? = null,
    public val id: String,
    public val launchType: String? = null,
    public val networkConfiguration: GetTaskExecutionNetworkConfiguration? = null,
    public val overrides: GetTaskExecutionOverrides? = null,
    public val placementConstraints: List<GetTaskExecutionPlacementConstraint>? = null,
    public val placementStrategies: List<GetTaskExecutionPlacementStrategy>? = null,
    public val platformVersion: String? = null,
    public val propagateTags: String? = null,
    public val referenceId: String? = null,
    public val startedBy: String? = null,
    public val tags: Map<String, String>? = null,
    public val taskArns: List<String>,
    public val taskDefinition: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.GetTaskExecutionResult): GetTaskExecutionResult = GetTaskExecutionResult(
            capacityProviderStrategies = javaType.capacityProviderStrategies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.GetTaskExecutionCapacityProviderStrategy.Companion.toKotlin(args0)
                })
            }),
            clientToken = javaType.clientToken().map({ args0 -> args0 }).orElse(null),
            cluster = javaType.cluster(),
            desiredCount = javaType.desiredCount().map({ args0 -> args0 }).orElse(null),
            enableEcsManagedTags = javaType.enableEcsManagedTags().map({ args0 -> args0 }).orElse(null),
            enableExecuteCommand = javaType.enableExecuteCommand().map({ args0 -> args0 }).orElse(null),
            group = javaType.group().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            launchType = javaType.launchType().map({ args0 -> args0 }).orElse(null),
            networkConfiguration = javaType.networkConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.GetTaskExecutionNetworkConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            overrides = javaType.overrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.GetTaskExecutionOverrides.Companion.toKotlin(args0)
                })
            }).orElse(null),
            placementConstraints = javaType.placementConstraints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.GetTaskExecutionPlacementConstraint.Companion.toKotlin(args0)
                })
            }),
            placementStrategies = javaType.placementStrategies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.GetTaskExecutionPlacementStrategy.Companion.toKotlin(args0)
                })
            }),
            platformVersion = javaType.platformVersion().map({ args0 -> args0 }).orElse(null),
            propagateTags = javaType.propagateTags().map({ args0 -> args0 }).orElse(null),
            referenceId = javaType.referenceId().map({ args0 -> args0 }).orElse(null),
            startedBy = javaType.startedBy().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            taskArns = javaType.taskArns().map({ args0 -> args0 }),
            taskDefinition = javaType.taskDefinition(),
        )
    }
}
