@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property alarmNames One or more CloudWatch alarm names.
 * @property enable Whether to use the CloudWatch alarm option in the service deployment process.
 * @property rollback Whether to configure Amazon ECS to roll back the service if a service deployment fails. If rollback is used, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
 */
public data class ServiceAlarms(
    public val alarmNames: List<String>,
    public val enable: Boolean,
    public val rollback: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.ServiceAlarms): ServiceAlarms =
            ServiceAlarms(
                alarmNames = javaType.alarmNames().map({ args0 -> args0 }),
                enable = javaType.enable(),
                rollback = javaType.rollback(),
            )
    }
}
