@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property enable Whether to enable the deployment circuit breaker logic for the service.
 * @property rollback Whether to enable Amazon ECS to roll back the service if a service deployment fails. If rollback is enabled, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
 */
public data class ServiceDeploymentCircuitBreaker(
    public val enable: Boolean,
    public val rollback: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.ServiceDeploymentCircuitBreaker): ServiceDeploymentCircuitBreaker = ServiceDeploymentCircuitBreaker(
            enable = javaType.enable(),
            rollback = javaType.rollback(),
        )
    }
}
