@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property containerName Name of the container to associate with the load balancer (as it appears in a container definition).
 * @property containerPort Port on the container to associate with the load balancer.
 * > **Version note:** Multiple `load_balancer` configuration block support was added in version 2.22.0 of the provider. This allows configuration of [ECS service support for multiple target groups](https://aws.amazon.com/about-aws/whats-new/2019/07/amazon-ecs-services-now-support-multiple-load-balancer-target-groups/).
 * @property elbName Name of the ELB (Classic) to associate with the service.
 * @property targetGroupArn ARN of the Load Balancer target group to associate with the service.
 */
public data class ServiceLoadBalancer(
    public val containerName: String,
    public val containerPort: Int,
    public val elbName: String? = null,
    public val targetGroupArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.ServiceLoadBalancer): ServiceLoadBalancer = ServiceLoadBalancer(
            containerName = javaType.containerName(),
            containerPort = javaType.containerPort(),
            elbName = javaType.elbName().map({ args0 -> args0 }).orElse(null),
            targetGroupArn = javaType.targetGroupArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
