@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property clientAlias List of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
 * @property discoveryName Name of the new AWS Cloud Map service that Amazon ECS creates for this Amazon ECS service.
 * @property ingressPortOverride Port number for the Service Connect proxy to listen on.
 * @property portName Name of one of the `portMappings` from all the containers in the task definition of this Amazon ECS service.
 * @property timeout Configuration timeouts for Service Connect
 * @property tls Configuration for enabling Transport Layer Security (TLS)
 */
public data class ServiceServiceConnectConfigurationService(
    public val clientAlias: List<ServiceServiceConnectConfigurationServiceClientAlias>? = null,
    public val discoveryName: String? = null,
    public val ingressPortOverride: Int? = null,
    public val portName: String,
    public val timeout: ServiceServiceConnectConfigurationServiceTimeout? = null,
    public val tls: ServiceServiceConnectConfigurationServiceTls? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.ServiceServiceConnectConfigurationService): ServiceServiceConnectConfigurationService = ServiceServiceConnectConfigurationService(
            clientAlias = javaType.clientAlias().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.ServiceServiceConnectConfigurationServiceClientAlias.Companion.toKotlin(args0)
                })
            }),
            discoveryName = javaType.discoveryName().map({ args0 -> args0 }).orElse(null),
            ingressPortOverride = javaType.ingressPortOverride().map({ args0 -> args0 }).orElse(null),
            portName = javaType.portName(),
            timeout = javaType.timeout().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.ServiceServiceConnectConfigurationServiceTimeout.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tls = javaType.tls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.ServiceServiceConnectConfigurationServiceTls.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
