@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dnsName Name that you use in the applications of client tasks to connect to this service.
 * @property port Listening port number for the Service Connect proxy. This port is available inside of all of the tasks within the same namespace.
 */
public data class ServiceServiceConnectConfigurationServiceClientAlias(
    public val dnsName: String? = null,
    public val port: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.ServiceServiceConnectConfigurationServiceClientAlias): ServiceServiceConnectConfigurationServiceClientAlias =
            ServiceServiceConnectConfigurationServiceClientAlias(
                dnsName = javaType.dnsName().map({ args0 -> args0 }).orElse(null),
                port = javaType.port(),
            )
    }
}
