@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property idleTimeoutSeconds Amount of time in seconds a connection will stay active while idle. A value of 0 can be set to disable idleTimeout.
 * @property perRequestTimeoutSeconds Amount of time in seconds for the upstream to respond with a complete response per request. A value of 0 can be set to disable perRequestTimeout. Can only be set when appProtocol isn't TCP.
 */
public data class ServiceServiceConnectConfigurationServiceTimeout(
    public val idleTimeoutSeconds: Int? = null,
    public val perRequestTimeoutSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.ServiceServiceConnectConfigurationServiceTimeout): ServiceServiceConnectConfigurationServiceTimeout =
            ServiceServiceConnectConfigurationServiceTimeout(
                idleTimeoutSeconds = javaType.idleTimeoutSeconds().map({ args0 -> args0 }).orElse(null),
                perRequestTimeoutSeconds = javaType.perRequestTimeoutSeconds().map({ args0 -> args0 }).orElse(null),
            )
    }
}
