@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property issuerCertAuthority Details of the certificate authority which will issue the certificate.
 * @property kmsKey KMS key used to encrypt the private key in Secrets Manager.
 * @property roleArn ARN of the IAM Role that's associated with the Service Connect TLS.
 */
public data class ServiceServiceConnectConfigurationServiceTls(
    public val issuerCertAuthority: ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthority,
    public val kmsKey: String? = null,
    public val roleArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.ServiceServiceConnectConfigurationServiceTls): ServiceServiceConnectConfigurationServiceTls = ServiceServiceConnectConfigurationServiceTls(
            issuerCertAuthority = javaType.issuerCertAuthority().let({ args0 ->
                com.pulumi.aws.ecs.kotlin.outputs.ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthority.Companion.toKotlin(args0)
            }),
            kmsKey = javaType.kmsKey().map({ args0 -> args0 }).orElse(null),
            roleArn = javaType.roleArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
