@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property managedEbsVolume Configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. See below.
 * @property name Name of the volume.
 */
public data class ServiceVolumeConfiguration(
    public val managedEbsVolume: ServiceVolumeConfigurationManagedEbsVolume,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.ServiceVolumeConfiguration): ServiceVolumeConfiguration = ServiceVolumeConfiguration(
            managedEbsVolume = javaType.managedEbsVolume().let({ args0 ->
                com.pulumi.aws.ecs.kotlin.outputs.ServiceVolumeConfigurationManagedEbsVolume.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
        )
    }
}
