@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property encrypted Whether the volume should be encrypted. Default value is `true`.
 * @property fileSystemType Linux filesystem type for the volume. For volumes created from a snapshot, same filesystem type must be specified that the volume was using when the snapshot was created. Valid values are `ext3`, `ext4`, `xfs`. Default value is `xfs`.
 * @property iops Number of I/O operations per second (IOPS).
 * @property kmsKeyId Amazon Resource Name (ARN) identifier of the Amazon Web Services Key Management Service key to use for Amazon EBS encryption.
 * @property roleArn Amazon ECS infrastructure IAM role that is used to manage your Amazon Web Services infrastructure. Recommended using the Amazon ECS-managed `AmazonECSInfrastructureRolePolicyForVolumes` IAM policy with this role.
 * @property sizeInGb Size of the volume in GiB. You must specify either a `size_in_gb` or a `snapshot_id`. You can optionally specify a volume size greater than or equal to the snapshot size.
 * @property snapshotId Snapshot that Amazon ECS uses to create the volume. You must specify either a `size_in_gb` or a `snapshot_id`.
 * @property throughput Throughput to provision for a volume, in MiB/s, with a maximum of 1,000 MiB/s.
 * @property volumeType Volume type.
 */
public data class ServiceVolumeConfigurationManagedEbsVolume(
    public val encrypted: Boolean? = null,
    public val fileSystemType: String? = null,
    public val iops: Int? = null,
    public val kmsKeyId: String? = null,
    public val roleArn: String,
    public val sizeInGb: Int? = null,
    public val snapshotId: String? = null,
    public val throughput: Int? = null,
    public val volumeType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.ServiceVolumeConfigurationManagedEbsVolume): ServiceVolumeConfigurationManagedEbsVolume = ServiceVolumeConfigurationManagedEbsVolume(
            encrypted = javaType.encrypted().map({ args0 -> args0 }).orElse(null),
            fileSystemType = javaType.fileSystemType().map({ args0 -> args0 }).orElse(null),
            iops = javaType.iops().map({ args0 -> args0 }).orElse(null),
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            roleArn = javaType.roleArn(),
            sizeInGb = javaType.sizeInGb().map({ args0 -> args0 }).orElse(null),
            snapshotId = javaType.snapshotId().map({ args0 -> args0 }).orElse(null),
            throughput = javaType.throughput().map({ args0 -> args0 }).orElse(null),
            volumeType = javaType.volumeType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
