@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property sizeInGib The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `21` GiB and the maximum supported value is `200` GiB.
 */
public data class TaskDefinitionEphemeralStorage(
    public val sizeInGib: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.TaskDefinitionEphemeralStorage): TaskDefinitionEphemeralStorage = TaskDefinitionEphemeralStorage(
            sizeInGib = javaType.sizeInGib(),
        )
    }
}
