@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property autoprovision If this value is `true`, the Docker volume is created if it does not already exist. *Note*: This field is only used if the scope is `shared`.
 * @property driver Docker volume driver to use. The driver value must match the driver name provided by Docker because it is used for task placement.
 * @property driverOpts Map of Docker driver specific options.
 * @property labels Map of custom metadata to add to your Docker volume.
 * @property scope Scope for the Docker volume, which determines its lifecycle, either `task` or `shared`.  Docker volumes that are scoped to a `task` are automatically provisioned when the task starts and destroyed when the task stops. Docker volumes that are scoped as `shared` persist after the task stops.
 */
public data class TaskDefinitionVolumeDockerVolumeConfiguration(
    public val autoprovision: Boolean? = null,
    public val driver: String? = null,
    public val driverOpts: Map<String, String>? = null,
    public val labels: Map<String, String>? = null,
    public val scope: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.TaskDefinitionVolumeDockerVolumeConfiguration): TaskDefinitionVolumeDockerVolumeConfiguration =
            TaskDefinitionVolumeDockerVolumeConfiguration(
                autoprovision = javaType.autoprovision().map({ args0 -> args0 }).orElse(null),
                driver = javaType.driver().map({ args0 -> args0 }).orElse(null),
                driverOpts = javaType.driverOpts().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                labels = javaType.labels().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            )
    }
}
