@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authorizationConfig Configuration block for authorization for the Amazon FSx for Windows File Server file system detailed below.
 * @property fileSystemId The Amazon FSx for Windows File Server file system ID to use.
 * @property rootDirectory The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
 */
public data class TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration(
    public val authorizationConfig: TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig,
    public val fileSystemId: String,
    public val rootDirectory: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration): TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration =
            TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration(
                authorizationConfig = javaType.authorizationConfig().let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig.Companion.toKotlin(args0)
                }),
                fileSystemId = javaType.fileSystemId(),
                rootDirectory = javaType.rootDirectory(),
            )
    }
}
